<?php

namespace MetaFox\Localize\Rules;

use Illuminate\Contracts\Validation\Rule as RuleContract;
use Illuminate\Support\Facades\Validator;
use MetaFox\Core\Support\Facades\Language;
use MetaFox\Platform\Rules\AllowInRule;

class TranslatableTextRule implements RuleContract
{
    protected bool $sometimes;

    public function __construct(bool $sometimes = false)
    {
        $this->sometimes = $sometimes;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function passes($attribute, $value): bool
    {
        if (!is_array($value)) {
            return true;
        }

        $defaultLanguage = Language::getDefaultLocaleId();
        $defaultRules    = array_merge(['string'], $this->sometimes ? ['sometimes', 'nullable'] : ['required']);

        $rules = [
            $defaultLanguage      => $defaultRules,
            'use_custom_language' => ['sometimes', 'numeric', new AllowInRule([0, 1])],
        ];

        $validator = Validator::make($value, $rules);

        return $validator->passes();
    }

    public function message(): string
    {
        return '';
    }

    public function sometimes(): self
    {
        $this->sometimes = true;

        return $this;
    }
}
