<?php

namespace MetaFox\Localize\Http\Resources\v1\CountryChild\Admin;

/*
 | --------------------------------------------------------------------------
 | DataGrid Configuration
 | --------------------------------------------------------------------------
 | stub: src/Http/Resources/v1/Admin/DataGrid.stub
 */

use MetaFox\Form\Html\BuiltinAdminSearchForm;
use MetaFox\Platform\Resource\Actions;
use MetaFox\Platform\Resource\GridConfig as Grid;
use MetaFox\Platform\Resource\ItemActionMenu;

/**
 * Class DataGrid.
 * @codeCoverageIgnore
 * @ignore
 */
class DataGrid extends Grid
{
    protected string $appName = 'localize';

    protected string $resourceName   = 'country.child';

    protected function initialize(): void
    {
        $this->setSearchForm(new BuiltinAdminSearchForm());

        $this->addColumn('name')
            ->header(__p('core::phrase.name'))
            ->linkTo('url')
            ->flex();

        $this->addColumn('state_iso')
            ->header(__p('localize::country.state_iso'))
            ->alignCenter()
            ->width(200);

        $this->addColumn('state_code')
            ->header(__p('localize::country.state_code'))
            ->alignCenter()
            ->width(200);

        $this->addColumn('country_iso')
            ->header(__p('core::phrase.country_iso'))
            ->alignCenter()
            ->width(200);

        $this->addColumn('fips_code')
            ->header(__p('localize::country.fips_code'))
            ->alignCenter()
            ->width(200);

        $this->addColumn('geonames_code')
            ->header(__p('localize::country.geonames_code'))
            ->alignCenter()
            ->width(200);

        /*
         * Add default actions
         */
        $this->withActions(function (Actions $actions) {
            $actions->addActions([]);

            $actions->add('editItem')
                ->apiUrl('admincp/core/form/localize.country_state.update/:id');

            $actions->add('deleteItem')
                ->apiUrl('admincp/localize/country/child/:id');
        });

        $this->withItemMenu(function (ItemActionMenu $menu) {
            $menu->withEdit()
                ->params(['action' => 'editItem']);

            $menu->withDelete()
                ->params(['action' => 'deleteItem']);
        });
    }
}
