<?php

namespace MetaFox\Localize\Http\Resources\v1\Country\Admin;

/*
 | --------------------------------------------------------------------------
 | DataGrid Configuration
 | --------------------------------------------------------------------------
 | stub: src/Http/Resources/v1/Admin/DataGrid.stub
 */

use MetaFox\Form\Html\BuiltinAdminSearchForm;
use MetaFox\Platform\Resource\Actions;
use MetaFox\Platform\Resource\GridConfig as Grid;
use MetaFox\Platform\Resource\ItemActionMenu;

/**
 * Class DataGrid.
 * @codeCoverageIgnore
 * @ignore
 */
class DataGrid extends Grid
{
    protected string $appName = 'localize';

    protected string $resourceName =  'country';

    protected function initialize(): void
    {
        $this->setSearchForm(new BuiltinAdminSearchForm());

        $this->setDefaultDataSource();

        $this->addColumn('country_iso')
            ->header(__p('core::phrase.country_iso'))
            ->width(200);

        $this->addColumn('name')
            ->header(__p('core::phrase.name'))
            ->linkTo('url')
            ->flex();

        $this->addColumn('is_active')
            ->header(__p('core::phrase.is_active'))
            ->asToggleActive();

        /*
         * Add default actions
         */
        $this->withActions(function (Actions $actions) {
            $actions->addActions(['edit', 'delete', 'destroy', 'toggleActive']);
            $this->actionAddState($actions);
        });

        $this->withItemMenu(function (ItemActionMenu $menu) {
            $menu->withEdit();
            $menu->withDelete();
            $this->addState($menu);
        });
    }

    protected function addState(ItemActionMenu $menu): void
    {
        $menu->addItem('addState')
            ->action('addState')
            ->icon('ico-plus-o')
            ->label(__p('localize::phrase.add_state'))
            ->reload()
            ->asAddRow()
            ->showWhen([]);
    }

    protected function actionAddState(Actions $actions): void
    {
        $actions->add('addState')
            ->asGet()
            ->apiUrl('admincp/core/form/localize.country_state.store/:id');
    }
}
