<?php

namespace MetaFox\Localize\Http\Requests\v1\CountryChild\Admin;

use Illuminate\Foundation\Http\FormRequest;
use MetaFox\Localize\Models\CountryChild;

/**
 * Class StoreRequest.
 */
class StoreRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'country_iso'   => ['required', 'string', 'exists:core_countries,country_iso'],
            'name'          => ['required', 'string', 'max:255'],
            'state_iso'     => ['string', 'required', 'unique:core_country_states,state_iso'],
            'state_code'    => ['numeric', 'required', 'unique:core_country_states,state_code'],
            'geonames_code' => ['numeric', 'required', 'unique:core_country_states,geonames_code'],
            'fips_code'     => ['string', 'required', 'unique:core_country_states,fips_code'],
        ];
    }

    public function validated($key = null, $default = null)
    {
        $data = parent::validated($key, $default);

        $data['ordering'] = 0;

        return $data;
    }
}
