<?php

namespace MetaFox\Layout\Repositories\Eloquent;

use Illuminate\Database\Eloquent\Collection;
use MetaFox\Platform\Repositories\AbstractRepository;
use MetaFox\Layout\Repositories\VariantRepositoryInterface;
use MetaFox\Layout\Models\Variant;
use MetaFox\Layout\Repositories\ThemeRepositoryInterface;

/**
 * stub: /packages/repositories/eloquent_repository.stub.
 */

/**
 * class VariantRepository.
 */
class VariantRepository extends AbstractRepository implements VariantRepositoryInterface
{
    public function model()
    {
        return Variant::class;
    }

    public function getActiveVariants(): Collection
    {
        $activeThemeIds = $this->themeRepository()->getActiveThemeIds();

        return Variant::query()
            ->whereIn('theme_id', $activeThemeIds)
            ->where('is_active', 1)
            ->orderBy('id')
            ->get();
    }

    public function getActiveVariantIds(): array
    {
        return $this->getActiveVariants()
            ->map(fn ($row) => sprintf('%s:%s', $row->theme_id, $row->variant_id))
            ->toArray();
    }

    private function themeRepository(): ThemeRepositoryInterface
    {
        return resolve(ThemeRepositoryInterface::class);
    }
}
