<?php

namespace MetaFox\Form\Html;

use MetaFox\Core\Support\Facades\AttachmentFileType;
use MetaFox\Form\Constants as MetaFoxForm;
use MetaFox\Platform\Facades\Settings;
use MetaFox\Platform\MetaFoxConstant;
use MetaFox\Yup\Yup;

/**
 * Class Attachment.
 */
class Attachment extends File
{
    public function initialize(): void
    {
        $accept = AttachmentFileType::getAllExtensionActive();
        $maxUploadFileSize = Settings::get('core.attachment.maximum_file_size_each_attachment_can_be_uploaded'); //in byte
        $maxFiles = Settings::get('core.attachment.maximum_number_of_attachments_that_can_be_uploaded');

        if (!empty($accept)) {
            $this->setAttribute('accept', '.' . implode(',.', $accept));
        }

        $component = empty($accept) ? MetaFoxForm::HIDDEN : MetaFoxForm::ATTACHMENT;

        $yup = Yup::array()
            ->of(Yup::object()
                ->addProperty('id', Yup::number()->required())
                ->addProperty('file_name', Yup::string()->required())
                ->addProperty('_destroy', Yup::number())
                ->addProperty('_new', Yup::number())
                ->addProperty('extension', Yup::string()
                    ->oneOf($accept)
                    ->setError('oneOf', __p('validation.mimes', [
                        'attribute' => 'file',
                        'values'    => implode(', ', $accept),
                    ])))
            );

        $this->component($component)
            ->name('attachments')
            ->label(__p('core::phrase.attachment'))
            ->placeholder(__p('core::phrase.attach_files'))
            ->variant('outlined')
            ->fullWidth()
            ->maxUploadSize($maxUploadFileSize)
            ->uploadUrl('/attachment')
            ->multiple(true)
            ->storageId('attachment')
            ->yup($yup);

        if ($maxFiles > 0) {
            $yup->maxWhen([
                'value' => $maxFiles,
                'when'  => [
                    'includes', 'item.status',
                    [MetaFoxConstant::FILE_CREATE_STATUS, MetaFoxConstant::FILE_NEW_STATUS],
                ],
            ], __p('core::phrase.maximum_per_upload_limit_reached', ['limit' => $maxFiles]))
                ->of(
                    Yup::object()
                        ->addProperty('id', Yup::number())
                        ->addProperty('type', Yup::string())
                        ->addProperty('status', Yup::string())
                );
        }
    }
}
