<?php

namespace App\Repositories;

use Illuminate\Support\Facades\Cache;
use Laravel\Passport\Passport;
use Laravel\Passport\TokenRepository;

class AuthTokenRepository extends TokenRepository
{
    public function find($id)
    {
        return Cache::rememberForever("auth_token($id)", fn () => Passport::token()->where('id', $id)->first());
    }

    public function revokeAccessToken($id)
    {
        Cache::forget("auth_token($id)");

        return parent::revokeAccessToken($id); // TODO: Change the autogenerated stub
    }
}
